TimeStart("Calculation")


-- For this tutorial, we will include a set of custom functions, that will make the code
-- shorter and increase readibility. The function dofile() simply appends the content of the 
-- specified file at the position where this function is called.

dofile("functions_Fabian.lua")

------------------------------------------------------------------------------------------------------------------------------------------
-- Initialize operators
------------------------------------------------------------------------------------------------------------------------------------------
-- For EuO, we will investigate the core level excitation from 3d to 4f.
-- This makes a total number of 24 spin orbitals. We define the 
NF=24
NB=0
IndexDn_3d = {0, 2, 4, 6, 8}
IndexUp_3d = {1, 3, 5, 7, 9}
IndexDn_4f = {10, 12, 14, 16, 18, 20, 22}
IndexUp_4f = {11, 13, 15, 17, 19, 21, 23}

-- The function get_operators_NF() creates all desired operators up to the Coulomb interaction
-- between two shells. One can enter an arbitrary number of shells. The last argument takes
-- a rotation matrix to directly receive the operators in the desired basis.
Opp = get_operators_NF(NF, {{"3d", IndexDn_3d, IndexUp_3d}, {"4f", IndexDn_4f, IndexUp_4f}}, nil)
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------




------------------------------------------------------------------------------------------------------------------------------------------
-- Initialize Eu2+
------------------------------------------------------------------------------------------------------------------------------------------
-- We define variables for the interaction energies obtained from a Hartree-Fock calculation
Ryd = 13.6

F0_4f = 2.0398645*Ryd
F2_4f = 0.9503917*Ryd
F4_4f = 0.5926381*Ryd
F6_4f = 0.4253442*Ryd

F0_3d4f = 2.8421169*Ryd
F2_3d4f = 0.5868624*Ryd
F4_3d4f = 0.2665610*Ryd

G1_3d4f = 0.4024913*Ryd
G3_3d4f = 0.2354934*Ryd
G5_3d4f = 0.1625512*Ryd

-- 4f spin orbit coupling will be neglected in this tutorial
zeta_4f = 0 --0.01175*Ryd
zeta_3d = 0.82050*Ryd

Hex = 0.1

Bz = 0.0000001

-- EuO has a 4f7 configuration.
StartRestrictions = {NF, NB, {"1111111111 00000000000000",10, 10}, {"0000000000 11111111111111",7, 7}}
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------





------------------------------------------------------------------------------------------------------------------------------------------
--Calculate lowest Eu2+ eigenstates
------------------------------------------------------------------------------------------------------------------------------------------
-- we define the 4f Hamiltonian without an exchange field and subtract the groundstate energy
Hamiltonian_0 = F0_4f*Opp["F0_4f"] + F2_4f*Opp["F2_4f"] + F4_4f*Opp["F4_4f"] + F6_4f*Opp["F6_4f"] + zeta_4f*Opp["ldots_4f"] + Bz*(Opp["Lz_4f"] + 2*Opp["Sz_4f"])
psi_0 = Eigensystem(Hamiltonian_0, StartRestrictions, 1)
Hamiltonian_0 = Hamiltonian_0 - psi_0*Hamiltonian_0*psi_0*Opp["1"]



-- EuO is a ferromagnet. Thus we want to include an exhcange field that aligns the spin in the z-direction
Hamiltonian_z = Hamiltonian_0 + Hex*Opp["Sz_4f"]


-- As we are at half filling, we end up in a L=0, S=7/2 ground state.
psiList = Eigensystem(Hamiltonian_z, StartRestrictions, 8)
print_expectation_values(psiList, {H = Hamiltonian_z, Sz = Opp["Sz_4f"], Lz = Opp["Lz_4f"], Jz = Opp["Jz_4f"], Ssqr = Opp["Ssqr_4f"], Lsqr = Opp["Lsqr_4f"], Jsqr = Opp["Jsqr_4f"]})
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------



TimeEnd("Calculation")
TimePrint()




